<?php
/**
 * Plugin Name: Divi Testimonial Extended
 * Plugin URI:  https://diviextended.com/product/divi-testimonial-extended/
 * Description: Display your client's review in an attractive & clean way with Divi Testimonial Extended plugin that adds testimonial slider module to Divi theme with multiple testimonial layouts, and custom post types for testimonials.
 * Version:     2.4.2
 * Author:      Elicus
 * Author URI:  https://elicus.com/
 * Upate URI:   https://diviextended.com/
 * License: 	GNU General Public License v2
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html/
 * Text Domain: divi-testimonial-extended
 * Domain Path: /languages
 */

defined( 'ABSPATH' ) || die( 'No script kiddies please!' );

define( 'ELICUS_TESTIMONIAL_VERSION', '2.4.2' );
define( 'ELICUS_TESTIMONIAL_OPTION', 'el-divi-testimonial-extended' );
define( 'ELICUS_TESTIMONIAL_BASENAME', plugin_basename( __FILE__ ) );

require_once plugin_dir_path( __FILE__ ) . 'includes/src/class-installation.php';
register_activation_hook( __FILE__, array( 'El_Testimonial_Extended_Installation', 'el_plugin_add_installs' ) );
register_deactivation_hook( __FILE__, array( 'El_Testimonial_Extended_Installation', 'el_plugin_remove_installs' ) );

if ( ! function_exists( 'el_testimonial_initialize_extension' ) ) {
	/**
	 * Creates the extension's main class instance.
	 *
	 * @since 1.0.0
	 */
	function el_testimonial_initialize_extension() {
		require_once plugin_dir_path( __FILE__ ) . 'includes/DiviTestimonialExtended.php';
	}
	add_action( 'divi_extensions_init', 'el_testimonial_initialize_extension' );
}
